{+------------------------------------------------------------
 | Unit Multidim
 |
 | Version: 1.0  Created: 05/26/96, 16:55:35
 |               Last Modified: 05/26/96, 16:55:35
 | Author : P. Below
 | Project: Array classes
 | Description:
 |   This is a brief sketch of how multidimensional arrays
 |   could be implemented based on the one-dimensional arrays
 |   class in Arrays.Pas. This class is bare of any error
 |   checking and would need quite a bit of work in this
 |   department!
 +------------------------------------------------------------}
Unit Multidim;
Interface

Uses Classes, Arrays;

Type
  TMultiDimArray = Class(TPersistent)
  private
    FStorage: TBaseArray;
    FBounds : TCardinalArray;

    Function  GetMaxIndex( dimension: Cardinal ): Cardinal;
  public
    Constructor Create( Const numItems: Array of Const;
                        datasize: Cardinal ); virtual;
    Destructor Destroy; override;
    Function OneDIndex(Const Indices: Array of Const): Cardinal;
    Procedure PutItem( Const Indices: Array of Const; Var data );
    Procedure GetItem( Const Indices: Array of Const; Var data );

    property MaxIndex[ dimension: Cardinal ]: Cardinal 
      read GetMaxIndex;
    property Storage: TBaseArray read FStorage;
  End;

Implementation

Uses SysUtils;

{+---------------------------
 | Methods of TMultiDimArray 
 +--------------------------}
Function  TMultiDimArray.GetMaxIndex( dimension: Cardinal ): Cardinal;
  Begin
    Result := Pred(FBounds[Pred(dimension)]);
  End; { TMultiDimArray.GetMaxIndex }
  
Constructor TMultiDimArray.Create( Const numItems: Array of Const;
                    datasize: Cardinal ); 
  Var
    i: Cardinal;
    total: Cardinal;
  Begin
    inherited Create;
    FBounds := TCardinalArray.Create( Succ(High(numItems)), 0);
    total := 1;
    For i:= 0 To High(numItems) Do Begin
      FBounds[i] := numItems[i].VInteger;
      total := total * numItems[i].VInteger;
    End; { For }

    FStorage := TBaseArray.Create( total, datasize );
  End; { TMultiDimArray.Create }
  
Destructor TMultiDimArray.Destroy; 
  Begin
    FStorage.Free;
    FBounds.Free;
    inherited Destroy;
  End; { TMultiDimArray.Destroy }
  
Function TMultiDimArray.OneDIndex(Const Indices: Array of Const): Cardinal;
  Var
    i: Cardinal;
    dimsize: Cardinal;
  Begin
    If High(Indices) = FBounds.MaxIndex Then Begin
      Result := 0;
      dimsize := 1;
      For i:= High(Indices)downto 0 Do Begin
        Result := Result + Indices[i].VInteger * dimsize;
        dimsize := dimsize * FBounds[i];
      End; { For }
    End { If }
    Else
      raise ERangeError.Create(
             'Number of indices does not match definition!');
  End; { TMultiDimArray.OneDIndex }
  
Procedure TMultiDimArray.PutItem( Const Indices: Array of Const; Var data );
  Begin
    FStorage.PutItem( OneDIndex(Indices), data );
  End; { TMultiDimArray.PutItem }
  
Procedure TMultiDimArray.GetItem( Const Indices: Array of Const; Var data );
  Begin
    FStorage.GetItem( OneDIndex(Indices), data );
  End; { TMultiDimArray.GetItem }
  

Initialization
End. { Unit Multidim }

